import React, { useEffect } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCircleCheck } from "@fortawesome/free-regular-svg-icons";
import { faChevronRight } from "@fortawesome/free-solid-svg-icons";
import { MdAssignmentAdd } from "react-icons/md";
import { useRouter } from "next/navigation";
import {
  faCirclePlay,
  faReply,
  faTrashCan,
} from "@fortawesome/free-solid-svg-icons";

export default function UpComingVideos({
  videoId,
  groupedVideos,
  handleVideoSelection,
  nextVideoVisible,
}) {
  const router = useRouter();

  const handleNavigate = (assignment_id, video_id) => {
    router.push(
      `/fill-assignment?assignment_id=${assignment_id}&video_id=${video_id}`
    );
  };
  return (
    <div className="md:w-[300px] bg-white p-4 md:pt-0">
      <h2 className="hidden md:block text-xl font-bold mb-3">
        Upcoming Videos
      </h2>
      <div className="max-h-[700px] overflow-y-auto pr-2 flex flex-col gap-3">
        {Object.entries(groupedVideos).map(([chapter, videos]) => (
          <div key={chapter} className="mb-4">
            <h3 className="text-xl font-semibold mb-2">{chapter}</h3>
            {videos.map((video, index) => (
              <div key={index}>
                {video?.is_video_completed === 1 && (
                  <>
                    {video?.assignment?.user_assignment_status === 1 || video?.assignment === null ?
                      <div
                        key={`${chapter}-${index}`}
                        className={`relative flex gap-4 px-2 py-3 mb-2 border rounded-lg cursor-pointer ${videoId !== video.video_id ? "border-green-500" : "border-golden"}`}
                        onClick={() => handleVideoSelection(video)}
                      >
                        <div className="flex items-center gap-2 pt-2">
                          <FontAwesomeIcon
                            icon={faCirclePlay}
                            className={`h-4 w-4 ${videoId !== video.video_id ? "text-green-500" : " text-golden"}`}
                          />
                          <div className={`text-sm font-normal ${videoId !== video.video_id ? "text-green-500" : "text-golden"}`}>
                            {video.video.title}
                          </div>
                          <FontAwesomeIcon
                            icon={faCircleCheck}
                            className="absolute top-5 right-1 h-4 w-4 text-green-500"
                          />
                        </div>
                      </div>
                      : <div
                        key={`${chapter}-${index}`}
                        className={`relative flex gap-4 px-2 py-3 mb-2 border rounded-lg cursor-pointer ${videoId !== video.video_id ? "border-gray-500" : "border-golden"}`}
                        onClick={() => handleVideoSelection(video)}
                      >
                        <div className="flex items-center gap-2 pt-2">
                          <FontAwesomeIcon
                            icon={faCirclePlay}
                            className={`h-4 w-4 ${videoId !== video.video_id ? "text-green-500" : " text-golden"}`}
                          />
                          <div className={`text-sm font-normal ${videoId !== video.video_id ? "text-green-500" : "text-golden"}`}>
                            {video.video.title}
                          </div>
                          <div
                            className="absolute top-5 right-1 h-4 w-4 cursor-pointer"
                            onClick={(e) => {
                              e.stopPropagation();
                              handleNavigate(video?.assignment?.id, video.id);
                            }}
                          >
                            <MdAssignmentAdd className="text-green-500" />
                          </div>
                        </div>
                      </div>
                    }
                  </>
                )}
                {video?.is_video_completed === 0 && (
                  <>
                    {nextVideoVisible.videoId === video.id ?
                      <div
                        key={`${chapter}-${index}`}
                        className={`relative flex gap-4 px-2 py-3 mb-2 border rounded-lg cursor-pointer ${videoId !== video.video_id ? "border-gray-500" : "border-golden"}`}
                        onClick={() => handleVideoSelection(video)}
                      >
                        <div className="flex items-center gap-2 pt-2">

                          <FontAwesomeIcon
                            icon={faCirclePlay}
                            className={`h-4 w-4 ${videoId !== video.video_id ? "text-gray-700" : "text-golden"}`}
                          />
                          <div className={`text-sm font-normal ${videoId !== video.video_id ? "text-gray-700" : "text-golden"}`}>
                            {video.video.title}
                          </div>
                          {video?.assignment?.user_assignment_status === 0 && (
                            <div
                              className="absolute top-5 right-1 h-4 w-4 cursor-pointer"
                              onClick={(e) => {
                                e.stopPropagation();
                                handleNavigate(video?.assignment?.id, video.id);
                              }}
                            >
                              <MdAssignmentAdd className="text-gray-700" />
                            </div>
                          )}
                        </div>
                      </div>
                      : <div
                        key={`${chapter}-${index}`}
                        className="relative flex gap-4 px-2 py-3 mb-2 border rounded-lg cursor-pointer opacity-50 pointer-events-none"
                        onClick={() => handleVideoSelection(video)}
                      >
                        <div className="flex items-center gap-2 pt-2">
                          <FontAwesomeIcon
                            icon={faCirclePlay}
                            className={`h-4 w-4 ${videoId !== video.video_id ? "text-gray-500" : " text-green-500"}`}
                          />
                          <div className="text-sm font-normal opacity-50">
                            {video.video.title}
                          </div>
                        </div>
                      </div>}
                  </>
                )}
              </div>
            ))}
          </div>

          // <div
          //   key={index}
          //   data-id={video.id}
          //   className={`relative flex gap-4 px-2 rounded-lg py-3 border mb-2 cursor-pointer ${video.is_video_completed
          //       ? "border-green-500"
          //       : nextVideoVisible.videoId === video.id
          //         ? "border-green-500"
          //         : "opacity-50 pointer-events-none"
          //     }`}
          //   onClick={() => handleVideoSelection(video)}
          // >
          //   <div className="flex items-center gap-2 pt-2">
          //     {video.is_video_completed ? (
          //       <FontAwesomeIcon
          //         icon={faCircleCheck}
          //         className="h-4 w-4 text-green-500"
          //       />
          //     ) : (
          //       <FontAwesomeIcon
          //         icon={faCirclePlay}
          //         className={`h-4 w-4 ${video.is_video_completed ? "text-[#d8a32b]" : ""
          //           }`}
          //       />
          //     )}
          //     <div
          //       className={`text-sm font-normal ${video.is_video_completed
          //           ? "text-green-500"
          //           : nextVideoVisible.videoId === video.id
          //             ? "text-green-500"
          //             : ""
          //         }`}
          //     >
          //       {video.video.title}
          //     </div>
          //     {video?.assignment?.id && (
          //       <div
          //         className="absolute top-5 right-1 h-4 w-4 cursor-pointer"
          //         onClick={(e) => {
          //           e.stopPropagation();
          //           handleNavigate(video?.assignment?.id, video.id);
          //         }}
          //       >
          //         <MdAssignmentAdd className="text-golden" />
          //       </div>
          //     )}
          //     {/* {nextVideoVisible.videoId === video.id && video?.assignment?.user_assignment_status !== 1 && (
          //         <div
          //           className="absolute top-5 right-1 h-4 w-4 cursor-pointer"
          //           onClick={(e) => {
          //             e.stopPropagation();
          //             handleNavigate(video?.assignment?.id, video.id);
          //           }}
          //         >
          //           <MdAssignmentAdd className="text-golden" />
          //         </div>
          //       )} */}
          //   </div>
          // </div>

        ))
        }
      </div >
    </div >
  );
}
